<Query Kind="Statements">
  <NuGetReference>Microsoft.CodeAnalysis.CSharp</NuGetReference>
  <Namespace>Microsoft.CodeAnalysis</Namespace>
  <Namespace>Microsoft.CodeAnalysis.CSharp</Namespace>
  <Namespace>Microsoft.CodeAnalysis.CSharp.Syntax</Namespace>
</Query>

var tree = CSharpSyntaxTree.ParseText (@"class Program
{
    static /*komentarz*/ void Main() {}
}");

SyntaxNode root = tree.GetRoot();

// wyszukanie tokena statycznego słowa kluczowego
var method = root.DescendantTokens().Single (t =>
   t.Kind() == SyntaxKind.StaticKeyword);

// umieszczenie drobiazgów wokół tokena statycznego słowa kluczowego
foreach (SyntaxTrivia t in method.LeadingTrivia)
	Console.WriteLine (new { Kind = "Leading " + t.Kind(), t.Span.Length });

foreach (SyntaxTrivia t in method.TrailingTrivia)
	Console.WriteLine (new { Kind = "Trailing " + t.Kind(), t.Span.Length });
